/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap.server;

import filenet.vw.base.logging.Logger;
import filenet.vw.server.VWBootstrapURL;
import java.io.Serializable;
import java.net.MalformedURLException;

class VWRouterInfo
implements Serializable {
    private static final long serialVersionUID = 464L;
    private String cpURI;
    private String fullURL;
    private String bsCEURI = null;
    private static Logger logger = Logger.getLogger("filenet.vw.soap.server");
    private static final String m_className = "VWRouterInfo";

    public static String _get_FILE_DATE() {
        return "$Date:   12 Oct 2006 01:09:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.12  $";
    }

    private VWRouterInfo() {
    }

    private void formatFullURL() throws MalformedURLException {
        this.fullURL = VWBootstrapURL.GetBootstrapURI(this.bsCEURI, this.cpURI);
        if (logger.isFinest()) {
            logger.finest(m_className, "formatfullURL", "final fullURL = " + this.fullURL);
        }
    }

    public VWRouterInfo(String fullCP) throws MalformedURLException {
        VWBootstrapURL bsURL = new VWBootstrapURL(fullCP);
        if (bsURL.getCEURI() != null) {
            this.bsCEURI = bsURL.getCEURI().toString();
        }
        this.cpURI = bsURL.getCPURI().toString();
        this.fullURL = bsURL.toString();
    }

    public VWRouterInfo(String cpURI, String bsCEURI) throws MalformedURLException {
        this.bsCEURI = bsCEURI;
        this.cpURI = cpURI;
        this.formatFullURL();
    }

    public String getBootstrapCEURI() {
        return this.bsCEURI;
    }

    public void setBootstrapCEURI(String ceURI) throws MalformedURLException {
        this.bsCEURI = ceURI;
        this.formatFullURL();
    }

    public String getCPURI() {
        return this.cpURI;
    }

    public String getFullURL() {
        return this.fullURL;
    }
}

